//adapted from Original http://glslsandbox.com/e#72144.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player by ET.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

const float PI = 3.0;
#define time u_Elapsed  //*0.3141592
#define resolution u_WindowSize
//
#define mouse vec4(0.0,0.0,0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif
//
void main( void) {
	vec2 p = gl_FragCoord.xy / vec2(max(resolution.x, resolution.y)) * 0.8;
	float t = time * 0.1;

	float l = 0.0;
	for (float i = 1.0; i < 11.0; i++) {
		p.x += 0.1 / i * cos(i * 8.0 * p.y + t + sin(t / 75.0));
		p.y += 0.1 / i * sin(i * 12.0 * p.x + t + cos(t / 120.0));
		l = length(vec2(0, p.y + sin(p.x * PI * i * ((sin(t / 3.0) + cos(t / 2.0)) * 0.25 + 0.5))));
	}

	float g = 1.0 - pow(l, 0.2);

	vec3 b = vec3(0.0, -1.0, -1.0);
	//vec3 a = vec3(1.0, 1.0, 1.0);
	vec3 a = vec3(0.8314, 0.6863, 0.2157); // Goldish color

	vec3 color = mix(a, b, g);
	gl_FragColor = vec4(color, 1.0);



}
